/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import filenet.vw.api.VWSession;
import filenet.vw.api.VWXMLConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.XMLHelper;
import filenet.vw.integrator.resources.VWResource;
import filenet.vw.server.VWCapsule;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.w3c.dom.Node;

public class PEComponentQueueHelper {
    private static String QUEUE_DEF_XML = null;
    private String m_PEUser;
    private String m_PEPw;
    private String m_PERouter;
    private VWSession m_vwSession = null;
    private boolean verbose = true;
    private boolean xmlOnly = false;

    public static String _get_FILE_DATE() {
        return "$Date:   28 Jan 2008 15:36:44  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }

    private boolean takeMethod(Method m, String[] Methods) {
        int nMethods = Methods.length;
        for (int i = 0; i < nMethods; ++i) {
            if (!m.getName().equals(Methods[i])) continue;
            return true;
        }
        return false;
    }

    private int getFieldType(String parameterTypeName) {
        if (parameterTypeName.equals("int")) {
            return 1;
        }
        if (parameterTypeName.equals("boolean")) {
            return 4;
        }
        if (parameterTypeName.equals("double")) {
            return 8;
        }
        if (parameterTypeName.equals("short")) {
            return 1;
        }
        if (parameterTypeName.equals("float")) {
            return 8;
        }
        if (parameterTypeName.equals("long")) {
            return 8;
        }
        if (parameterTypeName.equals("java.lang.Integer")) {
            return 1;
        }
        if (parameterTypeName.equals("java.lang.Boolean")) {
            return 4;
        }
        if (parameterTypeName.equals("java.lang.Double")) {
            return 8;
        }
        if (parameterTypeName.equals("java.lang.Short")) {
            return 1;
        }
        if (parameterTypeName.equals("java.lang.Float")) {
            return 8;
        }
        if (parameterTypeName.equals("java.lang.Long")) {
            return 8;
        }
        if (parameterTypeName.equals("java.util.Date")) {
            return 16;
        }
        if (parameterTypeName.equals("java.lang.String")) {
            return 2;
        }
        if (parameterTypeName.equals("filenet.vw.api.VWAttachment")) {
            return 32;
        }
        if (parameterTypeName.equals("filenet.vw.api.VWParticipant")) {
            return 64;
        }
        if (parameterTypeName.equals("[I")) {
            return 1;
        }
        if (parameterTypeName.equals("[Z")) {
            return 4;
        }
        if (parameterTypeName.equals("[D")) {
            return 8;
        }
        if (parameterTypeName.equals("[S")) {
            return 1;
        }
        if (parameterTypeName.equals("[F")) {
            return 8;
        }
        if (parameterTypeName.equals("[J")) {
            return 8;
        }
        if (parameterTypeName.equals("[Ljava.lang.Integer;")) {
            return 1;
        }
        if (parameterTypeName.equals("[Ljava.lang.Boolean;")) {
            return 4;
        }
        if (parameterTypeName.equals("[Ljava.lang.Double;")) {
            return 8;
        }
        if (parameterTypeName.equals("[Ljava.lang.Short;")) {
            return 1;
        }
        if (parameterTypeName.equals("[Ljava.lang.Float;")) {
            return 8;
        }
        if (parameterTypeName.equals("[Ljava.lang.Long;")) {
            return 8;
        }
        if (parameterTypeName.equals("[Ljava.util.Date;")) {
            return 16;
        }
        if (parameterTypeName.equals("[Ljava.lang.String;")) {
            return 2;
        }
        if (parameterTypeName.equals("[Lfilenet.vw.api.VWAttachment;")) {
            return 32;
        }
        if (parameterTypeName.equals("[Lfilenet.vw.api.VWParticipant;")) {
            return 64;
        }
        return -1;
    }

    private String getFieldTypeInString(String parameterTypeName) {
        if (parameterTypeName.equals("int")) {
            return "int";
        }
        if (parameterTypeName.equals("boolean")) {
            return "boolean";
        }
        if (parameterTypeName.equals("double")) {
            return "float";
        }
        if (parameterTypeName.equals("short")) {
            return "int";
        }
        if (parameterTypeName.equals("float")) {
            return "float";
        }
        if (parameterTypeName.equals("long")) {
            return "float";
        }
        if (parameterTypeName.equals("java.lang.Integer")) {
            return "int";
        }
        if (parameterTypeName.equals("java.lang.Boolean")) {
            return "boolean";
        }
        if (parameterTypeName.equals("java.lang.Double")) {
            return "float";
        }
        if (parameterTypeName.equals("java.lang.Short")) {
            return "int";
        }
        if (parameterTypeName.equals("java.lang.Float")) {
            return "float";
        }
        if (parameterTypeName.equals("java.lang.Long")) {
            return "float";
        }
        if (parameterTypeName.equals("java.util.Date")) {
            return "time";
        }
        if (parameterTypeName.equals("java.lang.String")) {
            return "string";
        }
        if (parameterTypeName.equals("filenet.vw.api.VWAttachment")) {
            return "attachment";
        }
        if (parameterTypeName.equals("filenet.vw.api.VWParticipant")) {
            return "participant";
        }
        if (parameterTypeName.equals("[I")) {
            return "int";
        }
        if (parameterTypeName.equals("[Z")) {
            return "boolean";
        }
        if (parameterTypeName.equals("[D")) {
            return "float";
        }
        if (parameterTypeName.equals("[S")) {
            return "int";
        }
        if (parameterTypeName.equals("[F")) {
            return "float";
        }
        if (parameterTypeName.equals("[J")) {
            return "float";
        }
        if (parameterTypeName.equals("[Ljava.lang.Integer;")) {
            return "int";
        }
        if (parameterTypeName.equals("[Ljava.lang.Boolean;")) {
            return "boolean";
        }
        if (parameterTypeName.equals("[Ljava.lang.Double;")) {
            return "float";
        }
        if (parameterTypeName.equals("[Ljava.lang.Short;")) {
            return "int";
        }
        if (parameterTypeName.equals("[Ljava.lang.Float;")) {
            return "float";
        }
        if (parameterTypeName.equals("[Ljava.lang.Long;")) {
            return "float";
        }
        if (parameterTypeName.equals("[Ljava.util.Date;")) {
            return "time";
        }
        if (parameterTypeName.equals("[Ljava.lang.String;")) {
            return "string";
        }
        if (parameterTypeName.equals("[Lfilenet.vw.api.VWAttachment;")) {
            return "attachment";
        }
        if (parameterTypeName.equals("[Lfilenet.vw.api.VWParticipant;")) {
            return "participant";
        }
        return null;
    }

    private String getOperationDescriptor(Method method) {
        try {
            VWXMLWrapper xmlWrapper = new VWXMLWrapper("fnpe_operation_descriptor", "http://www.filenet.com/xml/schemas/FNPE/1.0.0");
            Node rootNode = xmlWrapper.getRootNode();
            xmlWrapper.createNodeNamed(rootNode, "name", method.getName());
            xmlWrapper.createNodeNamed(rootNode, "description", "");
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int nIndex = 0; nIndex < parameterTypes.length; ++nIndex) {
                int nType = this.getFieldType(parameterTypes[nIndex].getName());
                if (nType == -1) {
                    System.out.println(VWResource.s_invalidParameterTypes.toString(method.getName()));
                    return null;
                }
                Node parameter = xmlWrapper.createNodeNamed(rootNode, "parameter", null);
                xmlWrapper.createNodeNamed(parameter, "name", "param" + (nIndex + 1));
                xmlWrapper.createNodeNamed(parameter, "type", Integer.toString(nType));
                xmlWrapper.createNodeNamed(parameter, "mode", Integer.toString(1));
                xmlWrapper.createNodeNamed(parameter, "isarray", String.valueOf(parameterTypes[nIndex].isArray()));
                xmlWrapper.createNodeNamed(parameter, "description", "");
            }
            Class<?> returnType = method.getReturnType();
            String returnTypeName = returnType.getName();
            if (returnTypeName != null && !returnTypeName.equals("void")) {
                int nType = this.getFieldType(returnTypeName);
                if (nType == -1) {
                    System.out.println(VWResource.s_invalidParameterTypes.toString(method.getName()));
                    return null;
                }
                Node parameter = xmlWrapper.createNodeNamed(rootNode, "parameter", null);
                xmlWrapper.createNodeNamed(parameter, "name", "return_value");
                xmlWrapper.createNodeNamed(parameter, "type", Integer.toString(nType));
                xmlWrapper.createNodeNamed(parameter, "mode", Integer.toString(2));
                xmlWrapper.createNodeNamed(parameter, "isarray", String.valueOf(returnType.isArray()));
                xmlWrapper.createNodeNamed(parameter, "description", "");
            }
            xmlWrapper.createNodeNamed(rootNode, "signature", method.toString());
            return xmlWrapper.toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private String formParamName(String baseName, String sType, int index, boolean isArray) {
        return sType.charAt(0) + baseName + (isArray ? "Arr" : "") + (index > 0 ? Integer.toString(index) : "");
    }

    private void appendOperationDefinition(Method method, StringBuffer buf) {
        try {
            buf.append("<OperationDefinition\nName=\"").append(method.getName()).append("\"\nDescription=\"\">");
            buf.append("\n<ArrayOfParameterDefinition>\n");
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int nIndex = 0; nIndex < parameterTypes.length; ++nIndex) {
                String sType = this.getFieldTypeInString(parameterTypes[nIndex].getName());
                if (sType == null) {
                    System.out.println(VWResource.s_invalidParameterTypes.toString(method.getName()));
                    return;
                }
                boolean isArray = parameterTypes[nIndex].isArray();
                buf.append("<Parameter Name=\"").append(this.formParamName("Param", sType, nIndex + 1, isArray)).append("\"\nDescription=\"\"\nValueExpr=\"\"\nType=\"").append(sType).append("\"\nIsArray=\"").append(String.valueOf(isArray)).append("\"\nMode=\"in\"/>\n");
            }
            Class<?> returnType = method.getReturnType();
            String returnTypeName = returnType.getName();
            if (returnTypeName != null && !returnTypeName.equals("void")) {
                String sType = this.getFieldTypeInString(returnTypeName);
                boolean isArray = returnType.isArray();
                buf.append("<Parameter Name=\"").append(this.formParamName("Ret", sType, 0, isArray)).append("\"\nDescription=\"\"\nValueExpr=\"\"\nType=\"").append(sType).append("\"\nIsArray=\"").append(String.valueOf(isArray)).append("\"\nMode=\"out\"/>\n");
            }
            buf.append("\n</ArrayOfParameterDefinition>\n");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void getVWSession() throws Exception {
        if (this.m_vwSession == null) {
            this.m_vwSession = new VWSession(this.m_PEUser, this.m_PEPw, this.m_PERouter);
        }
    }

    protected void setVerbose(boolean b) {
        this.verbose = b;
    }

    protected void setXmlOnly(boolean b) {
        this.xmlOnly = b;
    }

    public PEComponentQueueHelper(String PEUser, String PEPw, String PERouter) {
        this.m_PEUser = PEUser;
        this.m_PEPw = PEPw;
        this.m_PERouter = PERouter;
    }

    public void Register(String Queue2, String QueueUser, String QueuePw, String JAASContext2, String AdaptorClassName, String[] Methods) throws Exception {
        boolean takeAll = Methods == null;
        Class<?> importClass = this.getClass().getClassLoader().loadClass(AdaptorClassName);
        StringBuffer opBuf = new StringBuffer();
        if (importClass != null) {
            Method[] methods = importClass.getDeclaredMethods();
            for (int nIndex = 0; nIndex < methods.length; ++nIndex) {
                String s;
                if (!Modifier.isPublic(methods[nIndex].getModifiers())) continue;
                Method m = methods[nIndex];
                if (!takeAll && !this.takeMethod(m, Methods) || (s = this.getOperationDescriptor(m)) == null) continue;
                this.appendOperationDefinition(m, opBuf);
                opBuf.append("\n<ModelAttributes><ModelAttribute Name=\"F_OperationDescriptor\"").append("\nType=\"string\"\nIsArray=\"false\">\n<Value Val=\"").append(XMLHelper.toXMLString(s)).append("\"/>\n</ModelAttribute></ModelAttributes></OperationDefinition>");
            }
        }
        VWCapsule vwCapsule = new VWCapsule(QueuePw);
        QueuePw = vwCapsule.getStr();
        String s = QUEUE_DEF_XML;
        s = s.replaceAll("_CM_QueueName_", Queue2);
        s = s.replaceAll("_CM_AdaptorClass_", AdaptorClassName);
        s = s.replaceAll("_CM_UserName_", QueueUser);
        s = s.replaceAll("_CM_EncPassword_", QueuePw);
        s = s.replaceAll("_CM_JAASContext_", JAASContext2);
        s = s.replaceAll("_CM_OperationDescription_", opBuf.toString());
        if (this.verbose) {
            System.out.println(s);
        }
        if (this.xmlOnly) {
            return;
        }
        this.getVWSession();
        VWXMLConfiguration.importConfiguration(this.m_vwSession, s, 1);
        System.out.println("Done registering " + Queue2 + " with " + AdaptorClassName);
    }

    private static void printUsage() {
        System.out.println("PEComponentQueueHelper\n\t/PEuser PEUser\n\t/PEpw  PEPw\n\t/PErouter routername\n\t/queue queueName\n\t[/user username]\n\t[/pw pw ]\n\t/JAAS jassContextName\n\t/class  className \n\t[/methods name1,name2,name3,....]\n\t[/merge]\n\t[/verbose]\n\t[/xmlOnly]");
        System.out.println("\nThe first 3 parameters are required to obtain a VWSession, unless xmlOnly is specified.");
        System.out.println("\nThe default values of username and pw are PEUser and PEPw.\nEven if xmlOnly is specified, these values need to be present.");
        System.out.println("\nThe default if merge is not specified is replace the queue definition.");
        System.out.println("\nUse methods to specify the list of the method names.  If not specified, the default is to import all the public methods.  Note that only methods containing parameters of types supported by PE such as boolean, int, Date, String, VWAttachment, VWParticipant.  If the methods containing any non-acceptable types, it will not be available as a queue method.");
        System.out.println("\nUse xmlOnly to produce the XML that will be used for reconfiguring the queue.");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.isPresent("H") || c.isPresent("h") || c.isPresent("?")) {
                PEComponentQueueHelper.printUsage();
            }
            String PEUser = c.getParameter("PEuser");
            String PEPw = c.getParameter("PEpw");
            String PERouter = c.getParameter("PErouter");
            String queue = c.getParameter("queue");
            String user = c.getParameter("user", PEUser);
            String pw = c.getParameter("pw", PEPw);
            String JAAS = c.getParameter("JAAS", "CELogin");
            String adaptorClass = c.getParameter("class");
            String _methods = c.getParameter("methods");
            boolean xmlOnly = c.isPresent("xmlOnly");
            boolean verbose = c.isPresent("verbose") || xmlOnly;
            String[] methods = null;
            if (_methods != null) {
                methods = _methods.split(",");
            }
            if (!xmlOnly && (PEUser == null || PEPw == null || PERouter == null) || xmlOnly && (user == null || pw == null) || queue == null || adaptorClass == null) {
                PEComponentQueueHelper.printUsage();
            }
            PEComponentQueueHelper aQueueHelper = new PEComponentQueueHelper(PEUser, PEPw, PERouter);
            aQueueHelper.setVerbose(verbose);
            aQueueHelper.setXmlOnly(xmlOnly);
            aQueueHelper.Register(queue, user, pw, JAAS, adaptorClass, methods);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            InputStream in = PEComponentQueueHelper.class.getResourceAsStream("queueDefTemplate.xml");
            int size = in.available();
            byte[] b = new byte[size];
            in.read(b);
            QUEUE_DEF_XML = new String(b, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

